<?php 
if (empty($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    exit("NOPE");
}

if ($_FILES['file']['size'] > 500 * 1024 * 1024) {
    http_response_code(413);
    exit("TOO_BIG");
}

$ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
if ($ext !== 'zip') {
    http_response_code(415);
    exit("INVALID_TYPE");
}

$uploadDir = 'uploads/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$timestamp = date('Y-m-d_H-i-s');
$unique = uniqid('', true);  // more entropy
$filename = "macOS.c_{$timestamp}_{$unique}.zip";
$filepath = $uploadDir . $filename;

if (move_uploaded_file($_FILES['file']['tmp_name'], $filepath)) {
    $log = date('Y-m-d H:i:s') . " - Received: {$filename} "
         . "({$_FILES['file']['size']} bytes) from {$_SERVER['REMOTE_ADDR']}\n";
    file_put_contents($uploadDir . 'upload.log', $log, FILE_APPEND | LOCK_EX);

    http_response_code(200);
    echo "OK";
} else {
    http_response_code(500);
    echo "NOT_OK";
}
